' ********** Copyright 2019 Roku Corp.  All Rights Reserved. **********

sub Show(args as object)
    m.lib = m.top.FindNode("SampleComponentLib")
    m.lib.observeField("loadStatus", "onLoadStatusChanged")

    if IsDeepLinking(args)
        PerformDeepLinking(args)
    end if

    m.global.ObserveField("dialog", "ondialogShow", true)

    m.top.signalBeacon("AppLaunchComplete")
end sub

function onLoadStatusChanged(event as object)
    if event.getData() = "ready"
        prepareScreen()
    end if
end function

function prepareScreen()
    m.prepareScreen = CreateObject("roSGNode", "SampleComponentLib:prepareScreen")
    m.prepareScreen.ObserveField("screen", "OnChangeScreen")
    m.prepareScreen.ObserveField("ShowError", "OnChangeShowError")
    m.top.ComponentController.CallFunc("show", {
        view: m.prepareScreen
    })
end function

function OnChangeShowError(event as object)
    m.CodeScreen.Error = event.getData()
end function


function ShowLoginScreen()
    m.LoginScreen = CreateObject("roSGNode", "SampleComponentLib:LoginScreen")
    m.LoginScreen.ObserveField("screen", "OnChangeScreen")
    m.top.ComponentController.CallFunc("show", {
        view: m.LoginScreen
    })
end function

function ShowCodeScreen()
    m.CodeScreen = CreateObject("roSGNode", "SampleComponentLib:CodeLogin")
    m.CodeScreen.ObserveField("screen", "OnChangeScreen")
    m.top.ComponentController.CallFunc("show", {
        view: m.CodeScreen
    })
end function

function ShowFirstLogin()
    m.FirstLoginScreen = CreateObject("roSGNode", "SampleComponentLib:FirstLoginScreen")
    m.FirstLoginScreen.ObserveField("screen", "OnChangeScreen")
    m.top.ComponentController.CallFunc("show", {
        view: m.FirstLoginScreen
    })
end function

function ShowHomeScreen()
    m.HomeScreen = CreateObject("roSGNode", "SampleComponentLib:HomeScreen")
    m.HomeScreen.ObserveField("screen", "OnChangeScreen")
    m.HomeScreen.ObserveField("Error", "OnChangeError")
    m.HomeScreen.FindNode("Menu").ObserveField("rowItemSelected", "OnMenurowItemSelected")
    m.HomeScreen.FindNode("FavData").ObserveField("rowItemSelected", "OnFavDatarowItemSelected")
    m.top.ComponentController.CallFunc("show", {
        view: m.HomeScreen
    })
end function

function ShowSearchScreen()
    m.SearchScreen = CreateObject("roSGNode", "SampleComponentLib:SearchScreen")
    m.SearchScreen.ObserveField("screen", "OnChangeScreen")
    m.SearchScreen.FindNode("RowListData").ObserveField("rowItemSelected", "OnRowListDataItemSelected")
    m.top.ComponentController.CallFunc("show", {
        view: m.SearchScreen
    })
end function

function ShowLiveTvScreen()
    m.LiveTvScreen = CreateObject("roSGNode", "SampleComponentLib:LiveTvScreen")
    m.LiveTvScreen.ObserveField("screen", "OnChangeScreen")
    m.top.ComponentController.CallFunc("show", {
        view: m.LiveTvScreen
    })
end function

function ShowMovieScreen()
    m.MovieScreen = CreateObject("roSGNode", "SampleComponentLib:MovieScreen")
    m.MovieScreen.ObserveField("screen", "OnChangeScreen")
    m.MovieScreen.FindNode("MovieRowList").ObserveField("rowItemSelected", "OnMovierowItemSelected")
    m.top.ComponentController.CallFunc("show", {
        view: m.MovieScreen
    })
end function

function ShowSeriesScreen()
    m.SeriesScreen = CreateObject("roSGNode", "SampleComponentLib:SeriesScreen")
    m.SeriesScreen.ObserveField("screen", "OnChangeScreen")
    m.SeriesScreen.FindNode("SeriesRowList").ObserveField("rowItemSelected", "OnSeriesrowItemSelected")
    m.top.ComponentController.CallFunc("show", {
        view: m.SeriesScreen
    })
end function

function ShowCatchupScreen()
    m.CatchupScreen = CreateObject("roSGNode", "SampleComponentLib:CatchupScreen")
    m.CatchupScreen.ObserveField("StreamVideoData", "OnChangeStreamVideoData")
    m.top.ComponentController.CallFunc("show", {
        view: m.CatchupScreen
    })
end function

function ShowFavItemData()
    m.FavItemData = CreateObject("roSGNode", "SampleComponentLib:FavItemData")
    m.FavItemData.ObserveField("screen", "OnChangeScreen")
    m.FavItemData.FindNode("FavLiveRowList").ObserveField("rowItemSelected", "OnLiverowItemSelected")
    m.FavItemData.FindNode("FavMovieRowList").ObserveField("rowItemSelected", "OnMovierowItemSelected")
    m.FavItemData.FindNode("FavSeriesRowList").ObserveField("rowItemSelected", "OnSeriesrowItemSelected")
    m.top.ComponentController.CallFunc("show", {
        view: m.FavItemData
    })
end function

function ShowProgrammeGuide()
    m.ProgrammeGuide = CreateObject("roSGNode", "SampleComponentLib:ProgrammeGuide")
    m.ProgrammeGuide.ObserveField("screen", "OnChangeScreen")
    m.top.ComponentController.CallFunc("show", {
        view: m.ProgrammeGuide
    })
end function

function ShowSettingScreen()
    m.SettingScreen = CreateObject("roSGNode", "SampleComponentLib:SettingScreen")
    m.top.ComponentController.CallFunc("show", {
        view: m.SettingScreen
    })
end function

function ShowCategoryAllData(event)
    m.CategoryAllData = CreateObject("roSGNode", "SampleComponentLib:CategoryAllData")
    m.CategoryAllData.FindNode("RowListData").ObserveField("rowItemSelected", "OnFavDatarowItemSelected")
    m.CategoryAllData.contentData = event
    m.top.ComponentController.CallFunc("show", {
        view: m.CategoryAllData
    })
end function

function ShowMovieDetails(event)
    m.MovieDetails = CreateObject("roSGNode", "SampleComponentLib:MovieDetails")
    if event.stream_id <> invalid
        m.MovieDetails.ids = event.stream_id.toStr()
    else
        m.MovieDetails.ids = event.id
    end if
    m.top.ComponentController.CallFunc("show", {
        view: m.MovieDetails
    })
end function

function ShowSeriesDetails(event)
    m.SeriesDetails = CreateObject("roSGNode", "SampleComponentLib:SeriesDetails")
    if event.series_id <> invalid
        m.SeriesDetails.ids = event.series_id.toStr()
    else
        m.SeriesDetails.ids = event.id
    end if
    m.SeriesDetails.ObserveField("EpisodeData", "OnChangeEpisodeData")
    m.top.ComponentController.CallFunc("show", {
        view: m.SeriesDetails
    })
end function

function OnChangeError(event as object)
    m.LoginScreen.Error = event.getData()
end function

function OnChangeScreen(event as object)
    name = event.getData()
    if name = "HomeScreen"
        ShowHomeScreen()
    else if name = "LoginScreen"
        ShowLoginScreen()
    else if name = "FirstLoginScreen"
        ShowFirstLogin()
    else if name = "CodeScreen"
        ShowCodeScreen()
        ' m.prepareScreen.close = true
    else if name = "CloseCodeScreen"
        m.CodeScreen.close = true
        prepareScreen()
    else if name = "ChangeCode"
        ShowCodeScreen()
    else if name = "FirstScreenClose"
        m.FirstLoginScreen.close = true
        prepareScreen()
    else if name = "CloseFavScreen"
        m.FavItemData.close = true 
    else if name = "CloseEpg"
        m.ProgrammeGuide.close = true
    else if name = "CloseLive"
        m.LiveTvScreen.close = true
    else if name = "NoData"
        m.ProgrammeGuide.close = true
        data = {
            screen: "ProgrammeGuide"
            dialogType: "StandardMessageDialog"
            ErrorMassage: ["Epg Data Not Found"]
        }
        m.global.setFields({ dialog: FormatJson(data) })
    else if name = "ExitApp"
        m.top.exitChannel = true
    end if
end function

function OnMenurowItemSelected(event as object)
    Index = event.getData()
    Data = event.getRoSGNode().content.getChild(Index[0]).getChild(Index[1])
    if Data.title = "Search"
        ShowSearchScreen()
    else if Data.title = "Live"
        ShowLiveTvScreen()
    else if Data.title = "Movies"
        ShowMovieScreen()
    else if Data.title = "Series"
        ShowSeriesScreen()
    else if Data.title = "Catch up"
        ShowCatchupScreen()
    else if Data.title = "Favourite"
        ShowFavItemData()
    else if Data.title = "TV Guide"
        ShowProgrammeGuide()
    else if Data.title = "Setting"
        ShowSettingScreen()
    else if Data.title = "Logout"
        RegistryUtil().delete("username")
        RegistryUtil().delete("password")
        RegistryUtil().delete("ParentalPassword")
        RegistryUtil().delete("HideLiveData", m.global.username)
        RegistryUtil().delete("HideMovieData", m.global.username)
        RegistryUtil().delete("HideSeriesData", m.global.username)
        prepareScreen()
    end if
end function

function OnFavDatarowItemSelected(event as object)
    Index = event.getData()
    Data = event.getRoSGNode().content.getChild(Index[0]).getChild(Index[1])
    if Data.stream_type = "live"
        ?Data
        playVideo(Data)
        m.LiveData = Data
    else if Data.category = "Movie" or Data.stream_id <> invalid
        m.ShowData = Data
        Check = CheckData(m.global.HideMovie, Data.category_id)
        if Check = true
            ScreenKeyBoard("MovieScreen")
        else
            ShowMovieDetails(Data)
        end if
    else if Data.category = "Series" or Data.series_id <> invalid
        Check = CheckData(m.global.HideSeries, Data.category_id)
        m.ShowData = Data
        if Check = true
            ScreenKeyBoard("SeriesScreen")
        else
            ShowSeriesDetails(Data)
        end if
    end if
end function

function OnChangeStreamVideoData(event as object)
    Data = event.GetData()
    id = Data.id
    if Type(Data.data.stop_timestamp) = "roString" and Type(Data.data.start_timestamp) = "roString"
        Duration = Data.data.stop_timestamp.toInt() - Data.data.start_timestamp.toInt()
    else
        Duration = Data.data.stop_timestamp - Data.data.start_timestamp
    end if
    StartTime = enCodeTime(Data.data.start_timestamp)
    date = CreateObject("roDateTime")
    if type(Data.data.start_timestamp) = "roString"
        date.FromSeconds(Data.data.start_timestamp.toInt())
    else
        date.FromSeconds(Data.data.start_timestamp)
    end if
    Date = date.GetYear().tostr() + "-" + date.GetMonth().toStr() + "-" + date.GetDayOfMonth().toStr()
    content = CreateObject("roSGNode", "ContentNode")
    content.title = enCodeString(Data.data.title)
    content.url = m.global.api + "/timeshift/" + m.global.username + "/" + m.global.password + "/" + Duration.toStr() + "/" + Date + ":" + StartTime.toStr() + "/" + id.toStr() + ".ts"
    OpenVideoPlayer(content, 0, true)
end function

function OnRowListDataItemSelected(event as object)
    Index = event.getData()
    Data = event.getRoSGNode().content.getChild(Index[0]).getChild(Index[1])
    if Data.stream_type = "live"
        if Data <> invalid
            content = CreateObject("roSGNode", "ContentNode")
            content.title = Data.name
            content.url = m.global.api + "/live/" + m.global.username + "/" + m.global.password + "/" + Data.stream_id.toStr() + ".m3u8"
            OpenVideoPlayer(content, 0, true)
        end if
    else
        if Data.stream_id <> invalid
            m.ShowData = Data
            Check = CheckData(m.global.HideMovie, Data.category_id)
            if Check = true
                ScreenKeyBoard("MovieScreen")
            else
                ShowMovieDetails(Data)
            end if
        else if Data.series_id <> invalid
            Check = CheckData(m.global.HideSeries, Data.category_id)
            m.ShowData = Data
            if Check = true
                ScreenKeyBoard("SeriesScreen")
            else
                ShowSeriesDetails(Data)
            end if
        end if
    end if
end function

function OnLiverowItemSelected(event as object)
    Index = event.getData()
    Data = event.getRoSGNode().content.getChild(Index[0]).getChild(Index[1])
    m.LiveData = Data
    playVideo(Data)
end function

function playVideo(Data)
    VideoContent = CreateObject("roSGNode", "ContentNode")
    VideoContent.title = Data.TITLE
    VideoContent.url = m.global.api + "/live/" + m.global.username + "/" + m.global.password + "/" + Data.stream_id.toStr() + ".ts"
    videoContent.streamformat = "live"
    OpenVideoPlayer(VideoContent, 0, true)
end function

function OnMovierowItemSelected(event as object)
    Index = event.getData()
    Data = event.getRoSGNode().content.getChild(Index[0]).getChild(Index[1])
    if Data.id = "GetAllData"
        row = {}
        row.id = Data.category_id
        row.action = "get_vod_streams"
        row.title = Data.title
        ShowCategoryAllData(row)
    else
        m.ShowData = Data
        Check = CheckData(m.global.HideMovie, Data.category_id)
        if Check = true
            ScreenKeyBoard("MovieScreen")
        else
            ShowMovieDetails(Data)
        end if
    end if
end function

function OnSeriesrowItemSelected(event as object)
    Index = event.getData()
    Data = event.getRoSGNode().content.getChild(Index[0]).getChild(Index[1])
    if Data.id = "GetAllData"
        row = {}
        row.id = Data.category_id
        row.action = "get_series"
        row.title = Data.title
        ShowCategoryAllData(row)
    else
        Check = CheckData(m.global.HideSeries, Data.category_id)
        m.ShowData = Data
        if Check = true
            ScreenKeyBoard("SeriesScreen")
        else
            ShowSeriesDetails(Data)
        end if
    end if
end function

function OnChangeEpisodeData(event as object)
    Data = event.getData()
    m.SeriesDetails.id = "EpisodeDetails"
    if type(Data.EpisodeNumber) = "String" or type(Data.EpisodeNumber) = "roString"
        EpisodeNumber = Data.EpisodeNumber.toInt()
    else
        EpisodeNumber = Data.EpisodeNumber
    end if
    content = CreateObject("roSGNode", "ContentNode")
    for i = 0 to Data.Episode.Count()
        if Data.Episode[i] <> invalid
            item = CreateObject("roSGNode", "ContentNode")
            item.title = Data.Episode[i].title
            if type(Data.Episode[i].id) = "String" or type(Data.Episode[i].id) = "roString"
                id = Data.Episode[i].id.toint()
            else
                id = Data.Episode[i].id
            end if
            item.url = m.global.api + "/series/" + m.global.username + "/" + m.global.password + "/" + id.toStr() + "." + Data.Episode[i].container_extension
            ?m.global.api + "/series/" + m.global.username + "/" + m.global.password + "/" + id.toStr() + "." + Data.Episode[i].container_extension
            content.appendChild(item)
        end if
    end for
    OpenVideoPlayer(content, EpisodeNumber - 1, true)
end function

function ondialogShow(event as object)
    data = event.getdata()
    m.global.setFields({ dialog: true })
    if data <> invalid
        data = ParseJson(data)
        if data.dialogtype = "Keyboard"
            ShowsKeyboard(data)
        else if data.dialogtype = "PinKeyboard"
            ShowPinKeyboard(data)
        else if data.dialogType = "StandardMessageDialog"
            ShowStandardMessageDialog(data)
        end if
    end if
end function

function ShowStandardMessageDialog(Data as object)
    ?Data.ErrorMassage
    StandardMessageDialog = createObject("roSGNode", "StandardMessageDialog")
    if Data <> invalid
        if Data.screen = "SearchScreen"
            StandardMessageDialog.title = "Video Player"
            StandardMessageDialog.message = Data.ErrorMassage
        else if Data.screen = "ProgrammeGuide"
            StandardMessageDialog.title = "Tv Guide Screen"
            StandardMessageDialog.message = Data.ErrorMassage
        else if Data.screen = "FirstLogin"
            StandardMessageDialog.title = "Login"
            StandardMessageDialog.message = Data.ErrorMassage
        else if Data.screen = "CodeScreen"
            StandardMessageDialog.title = "Login"
            StandardMessageDialog.message = ["Please enter valid user credentials or check your subscription validity"]
        end if
    end if
    StandardMessageDialog.buttons = ["Dismiss"]
    StandardMessageDialog.observeFieldScoped("buttonSelected", "onButtonSelected")
    m.top.dialog = StandardMessageDialog
end function

function onButtonSelected()
    m.top.dialog.close = true
end function

function ShowsKeyboard(data as object)
    m.dialog = createObject("roSGNode", "KeyboardDialog")
    m.dialog.keyboard.textEditBox.secureMode = false
    if data.field = "searchText"
        m.dialog.title = "Search Content"
    else if data.field = "UsernameTextEditBox"
        m.dialog.title = "Enter username"
    else if data.field = "passwordTextEditBox"
        m.dialog.title = "Enter password"
    else if data.field = "UrlTextEditBox"
        m.dialog.title = "Enter Url"
    else if data.field = "exampleTextEditBox"
        m.dialog.title = "Enter Code"
    end if
    m.dialog.buttons = ["Enter"]
    m.dialog.update(data, true)
    m.dialog.message = ""
    m.dialog.observeField("buttonSelected", "HandleKeyboardbutton")
    m.top.dialog = m.dialog
end function

function ShowPinKeyboard(data as object)
    m.Pindialog = createObject("roSGNode", "PinDialog")
    if data.field = "SetPassword" or data.field = "ConformPassword"
        m.Pindialog.title = "Enter Password"
    end if
    m.Pindialog.buttons = ["Enter"]
    m.Pindialog.update(data, true)
    m.Pindialog.observeField("buttonSelected", "HandlePinKeyboardbutton")
    m.top.dialog = m.Pindialog
end function


function HandleKeyboardbutton(event as object)
    data = m.top.dialog
    if data.screen <> invalid and data.field <> invalid
        if event.getData() = 0
            if data.screen = "SearchScreen"
                m.SearchScreen.CallFunc("SetText", { field: data.field, text: m.dialog.text })
            else if data.screen = "LoginScreen"
                if data.field = "UsernameTextEditBox"
                    m.LoginScreen.CallFunc("UserText", { field: data.field, text: m.dialog.text })
                else if data.field = "passwordTextEditBox"
                    m.LoginScreen.CallFunc("PassText", { field: data.field, text: m.dialog.text })
                else if data.field = "UrlTextEditBox"
                    m.LoginScreen.CallFunc("UrlText", { field: data.field, text: m.dialog.text })
                end if
            else if data.screen = "FirstLoginScreen"
                if data.field = "UsernameTextEditBox"
                    m.FirstLoginScreen.CallFunc("UserText", { field: data.field, text: m.dialog.text })
                else if data.field = "passwordTextEditBox"
                    m.FirstLoginScreen.CallFunc("PassText", { field: data.field, text: m.dialog.text })
                end if
            else if data.screen = "CodeScreen"
                m.CodeScreen.CallFunc("LoginCode", { field: data.field, text: m.dialog.text })
            end if
        end if
    end if
    m.top.dialog.close = true
end function

function HandlePinKeyboardbutton(event as object)
    data = m.top.dialog
    if data.screen <> invalid and data.field <> invalid
        if event.getData() = 0
            if data.screen = "ParentalScreen"
                if data.field = "SetPassword" or data.field = "Password"
                    m.SettingScreen.CallFunc("PassText", { field: data.field, text: data.pin })
                else if data.field = "NewPassword"
                    m.SettingScreen.CallFunc("NewPText", { field: data.field, text: data.pin })
                else if data.field = "ConformPassword"
                    m.SettingScreen.CallFunc("CPassText", { field: data.field, text: data.pin })
                end if
            else if data.screen = "SeriesScreen"
                if RegistryUtil().read("ParentalPassword") = data.pin
                    ShowSeriesDetails(m.ShowData)
                else
                    if m.SeriesScreen = invalid
                        m.HomeScreen.Error = "Please Enter Valid Pin"
                    else
                        m.SeriesScreen.Error = "Please Enter Valid Pin"
                    end if
                end if
            else if data.screen = "MovieScreen"
                if RegistryUtil().read("ParentalPassword") = data.pin
                    ShowMovieDetails(m.ShowData)
                else
                    if m.MovieScreen = invalid
                        m.HomeScreen.ShowError = "Please Enter Valid Pin"
                    else
                        m.MovieScreen.Error = "Please Enter Valid Pin"
                    end if
                end if
            else if data.screen = "LiveScreen"
                m.LiveTvScreen.CallFunc("PassWord", { field: data.field, text: data.pin })
            end if
        end if
    end if
    m.top.dialog.close = true
end function

function ScreenKeyBoard(screen)
    data = {
        screen: screen
        dialogType: "PinKeyboard"
        field: "EnterPassword"
    }
    m.global.setFields({ dialog: FormatJson(data) })
end function

function CheckData(Result, Checkid)
    return ArrayUtil().contains(Result, Checkid)
end function

sub Input(args as object)
    ' handle roInput event deep linking
    if IsDeepLinking(args)
        PerformDeepLinking(args)
    end if
end sub
