' ********** Copyright 2017 Roku Corp.  All Rights Reserved. **********

' Converts associative array to a node of a given type
' @param inputAA associative array, which will be transformed to roSGNode
' @param nodeType type of node, which will be created
function Utils_AAToNode(inputAA = {} as Object, nodeType = "Node" as String) as Object
    node = createObject("roSGNode", nodeType)

    Utils_forceSetFields(node, inputAA)

    return node
end function


'converts AA to ContentNode
Function Utils_AAToContentNode(inputAA = {} as Object, nodeType = "ContentNode" as String)
    return Utils_AAToNode(inputAA, nodeType)
End Function


' Force sets fields to a given node. If node doesn't have a field, it adds it and then sets
' @param node roSGNode, to which you want to set fields
' @param fieldsToSet associative array of field names and values to be set
sub Utils_forceSetFields(node as Object, fieldsToSet as Object)
    ' if not fw_isSGNode(node) or not fw_isAssociativeArray(fieldsToSet) then return

    existingFields = {}
    newFields = {}

      'AA of node read-only fields for filtering'
    fieldsFilterAA = {
        focusedChild    :   "focusedChild"
        change          :   "change"
        metadata        :   "metadata"
    }

    for each field in fieldsToSet
        if node.hasField(field)
            if NOT fieldsFilterAA.doesExist(field) then existingFields[field] = fieldsToSet[field]
        else
            newFields[field] = fieldsToSet[field]
        end if
    end for

    node.setFields(existingFields)
    node.addFields(newFields)
end sub


'converts array of AAs to content node with child content nodes
Function Utils_ContentList2Node(contentList as Object) as Object
    result = createObject("roSGNode","ContentNode")

    for each itemAA in contentList
        item = Utils_AAToContentNode(itemAA, "ContentNode")
        result.appendChild(item)
    end for

    return result
End Function

function RegistryUtil() as Object
    registry = {
        write: function(key as String, val as String, section = "default" as String) as Void
            sec = createObject("roRegistrySection", section)
            sec.write(key, val)
            sec.flush()
        end function


        read: function(key as String, section = "default" as String) as Dynamic
            sec = createObject("roRegistrySection", section)
            if sec.exists(key) then return sec.read(key)
            return invalid
        end function


        readSection: function(section = "default" as String) as Object
            sec = createObject("roRegistrySection", section)
            aa = {}
            keyList = sec.getKeyList()
            for each key in keyList
                aa[key] = m.read(key, section)
            end for
            return aa
        end function

        delete: function(key as String, section = "default" as String) as Dynamic
            sec = createObject("roRegistrySection", section)
            if sec.exists(key) then return sec.delete(key)
            return invalid
        end function

   
        deleteSection: function(section = "default" as String) as Boolean
            reg = createObject("roRegistry")
            return reg.delete(section)
        end function

  
        clear: function()
            sectionList = m.getSections()
            for each section in sectionList
                m.deleteSection(section)
            end for
        end function

        getSections: function() as Object
            reg = createObject("roRegistry")
            return reg.getSectionList()
        end function
    }

    return registry
end function

function enCodeTime(content)
    date = CreateObject("roDateTime")
    if type(content) = "roString" or type(content) = "String"
        date.FromSeconds(content.toInt())
    else
        date.FromSeconds(content)
    end if
    if date.GetHours() < 10 and date.GetMinutes() < 10
        m.Time = "0" + date.GetHours().toStr() + ":0" + date.GetMinutes().toStr()
    else if date.GetHours() < 10
        m.Time = "0" + date.GetHours().toStr() + ":" + date.GetMinutes().toStr()
    else if date.GetMinutes() < 10
        m.Time = date.GetHours().toStr() + ":0" + date.GetMinutes().toStr()
    else
        m.Time = date.GetHours().toStr() + ":" + date.GetMinutes().toStr()
    end if
    return m.Time
end function

function enCodedate(content)
    date = CreateObject("roDateTime")
    if type(content) = "roString" or type(content) = "String"
        date.FromSeconds(content.toInt())
    else
        date.FromSeconds(content)
    end if
    return SetDay(date.GetDayOfMonth()) + " " + SetMonthandDate(date.GetMonth()) + " " + date.GetYear().tostr()
end function

function SetDay(Day)
    if Day < 10 then return "0" + Day.toStr()
    return Day.toStr()
end function

function SetMonthandDate(Time) as string
    if Time = 1 then return "Jan"
    if Time = 2 then return "Feb"
    if Time = 3 then return "Mar"
    if Time = 4 then return "Apr"
    if Time = 5 then return "May"
    if Time = 6 then return "Jun"
    if Time = 7 then return "Jul"
    if Time = 8 then return "Aug"
    if Time = 9 then return "Sep"
    if Time = 10 then return "Oct"
    if Time = 11 then return "Nov"
    if Time = 12 then return "Dec"
end function

function enCodeString(Str)
    ba = CreateObject("roByteArray")
    ba.FromAsciiString(Str)
    ba.FromBase64String(Str)
    return ba.ToAsciiString()
end function