' ********** Copyright 2019 Roku Corp.  All Rights Reserved. **********

' There are two functions depending on whether or not a focus index and isContentList are provided
function OpenVideoPlayer(content as object, index as integer, isContentList as boolean) as object
    ' Create MediaView Object and set its fields
    video = CreateObject("roSGNode", "MediaView")
    video.content = content
    video.jumpToItem = index
    video.isContentList = isContentList
    ' Set it to start playing, it wont begin playback until show() is called
    video.ObserveField("state", "onCheckstate")
    video.ObserveField("state", "OnHomeScreenState")
    video.control = "play"
    ' Show the media view
    m.top.ComponentController.CallFunc("show", {
        view: video
    })
    return video
end function

function onCheckstate(event as object)
    if event.getData() = "error"
        m.global.VideplayerError = event.getData()
    end if
end function

function OnHomeScreenState(event as object)
    if event.getData() = "error"
        m.global.VideplayerError = event.getData()
    end if
end function

function OpenVideoPlayerItem(contentItem as object) as object
    ' Create MediaView Object and set its fields
    video = CreateObject("roSGNode", "MediaView")
    video.content = contentItem
    video.isContentList = false
    ' Set it to start playing, it wont begin playback until show() is called
    video.control = "play"
    ' Show the media view
    m.top.ComponentController.CallFunc("show", {
        view: video
    })
    return video
end function

' function PlayVideo()
'     content = CreateObject("roSGNode", "contentnode")
'     content.url = "pkg:/images/purple-luncher.mp4"
'     ?content
'     video = CreateObject("roSGNode", "VideoView")
'     video.content = content
'     video.isContentList = false
'     ' Set it to start playing, it wont begin playback until show() is called
'     video.control = "play"
'     ' Show the media view
'     m.top.ComponentController.CallFunc("show", {
'         view: video
'     })
'     video.observeField("state","onChangeState")
'     return video
' end function

' function onChangeState(event as object)
'     ?event.getData()
' end function